% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellCounts.R
\name{computeCellCounts}
\alias{computeCellCounts}
\title{Get cell counts with metadata}
\usage{
computeCellCounts(sce, annotation, sampleIDs)
}
\arguments{
\item{sce}{\code{SingleCellExperiment}}

\item{annotation}{string indicating column in \code{colData(sce)} storing cell type annotations}

\item{sampleIDs}{string indicating column in \code{colData(sce)} storing sample identifers}
}
\value{
\code{matrix} storing cell counts
}
\description{
Get cell counts with metadata for each sample
}
\examples{
library(muscat)
library(SingleCellExperiment)

data(example_sce)

counts <- computeCellCounts(example_sce, "cluster_id", "sample_id")

counts[1:4, 1:4]

}
