% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiN.R
\name{HeatmapOP}
\alias{HeatmapOP}
\title{Heatmap.}
\usage{
HeatmapOP(
  x,
  col = "RdYlGn",
  colNA = "grey",
  coln = 11,
  bordercol = "grey",
  borderwidth = 0.1,
  breaks = "sym",
  main = "",
  sub = "",
  dendrogram = "none",
  colorkey = "right",
  Colv = TRUE,
  Rowv = TRUE,
  xrot = 90,
  yrot = 0,
  shrink = c(1, 1),
  cexCol = 1,
  cexRow = 1,
  cexMain = 1,
  cexSub = 1,
  colSideColors = NULL,
  aspect = "fill",
  contour = FALSE,
  useRaster = FALSE,
  xlab = NULL,
  ylab = NULL,
  colSideColorsPos = "top",
  clust = NULL,
  clusterx = NULL,
  axis.padding = 0.5,
  legend = NULL,
  ...
)
}
\arguments{
\item{x}{Matrix.}

\item{col}{Color. See brewer.pal.info for all available
color schemes. Alternatively, any number of colors, which
 are then used to create a color gradient. E.g., c('blue','red')
  produces a color scheme with a gradient from blue to red.}

\item{colNA}{color for NAs; defaul is grey}

\item{coln}{Number of colors.}

\item{bordercol}{Border color.}

\item{borderwidth}{Border width.}

\item{breaks}{Defines the breaks in the color range. "sym"
makes the breaks symmetric around 0.}

\item{main}{Main title.}

\item{sub}{Subtitle.}

\item{dendrogram}{Draw dendrogram with "both", "col" or
"row", or do not draw with "none".}

\item{colorkey}{Draw colorkey "left", "right" (default), "top", "bottom"
or NULL for no colorkey. See ?lattice::levelplot for more complex colorkey
options.}

\item{Colv}{Cluster columns (TRUE) or not (FALSE).}

\item{Rowv}{Cluster rows (TRUE) or not (FALSE).}

\item{xrot}{Rotate the column names by degree.}

\item{yrot}{Rotate the row names by degree.}

\item{shrink}{c(x,y) defines a range of size for the data
boxes from low to high.}

\item{cexCol}{Font size of column names.}

\item{cexRow}{Font size of row names.}

\item{cexMain}{Font size of main title.}

\item{cexSub}{Font size of subtitle.}

\item{colSideColors}{Defines a numeric vector to annotate
columns with different colors.}

\item{aspect}{"iso" for quadratic boxes or "fill" for
streched boxes.}

\item{contour}{TRUE adds a contour plot.}

\item{useRaster}{TRUE to add raster visuals}

\item{xlab}{Label for the x-axis.}

\item{ylab}{Label for the y-axis.}

\item{colSideColorsPos}{Place colSideColors at the "top" or "bottom".}

\item{clust}{p, s, or k for correlation clustering}

\item{clusterx}{Optional data matrix y with the same dimensions
as x. x's columns or rows are sorted by the cluster information of y.
Col- and rownames of y must be in the same order as in x.}

\item{axis.padding}{padding around the heatmap (0.5 is no padding,
default)}

\item{legend}{list obejct. For parameters see base function ?legend for details. x and y parameters are relative to the inside of the heatmap and are between 0 and 1. E.g., to place the legend outside of the heatmap x and y need to be either less than 0 or greater than 1.}

\item{\dots}{Optional arguments.}
}
\value{
lattice object/matrix
}
\description{
Heatmap function based on the lattice package
more information: ?xyplot
}
\examples{
x <- matrix(rnorm(50), 10, 5)
HeatmapOP(x, dendrogram = "both", aspect = "iso", xrot = 45)
}
\author{
Martin Pirkl & Oscar Perpinan
at http://oscarperpinan.github.io/rastervis/
}
