% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{expStep}
\alias{expStep}
\title{E-step of HMM (forward-backward probability + posterior probability calculation)}
\usage{
expStep(pi, gamma, logf, hdf5)
}
\arguments{
\item{pi}{a vector of probabilities (sum of probabilities should sum to one)}

\item{gamma}{a matrix of transition probabilities (row sums should be one)}

\item{logf}{a matrix of observed log-likelihood values. Columns represent
hidden states, rows represent genomic regions}

\item{hdf5}{path to where the hdf5 is saved}
}
\description{
E-step of HMM (forward-backward probability + posterior probability calculation)
}
\examples{
#Creating dummy object
countData <- rbind(matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1),
                  matrix(rnbinom(2e3,mu = 7.5,size = 5),ncol = 1),
                  matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1))



colData <- data.frame(condition = 'A', replicate = 1)
object <- epigraHMMDataSetFromMatrix(countData,colData)

#Initializing
object <- initializer(object,controlEM())

#Running epigraHMM
object <- epigraHMM(object,controlEM(),type = 'consensus',dist = 'nb')

#Example
expStep(pi = c(0.99,0.02),
       gamma = matrix(c(0.99,0.01,0.01,0.99),nrow = 2),
       logf = cbind(dnbinom(rnbinom(100,mu = 2,size = 10),mu = 2,size = 10,log = TRUE),
                    dnbinom(rnbinom(100,mu = 7.5,size = 5),mu = 7.5,size = 5,log = TRUE)),
       hdf5 = file.path(tempdir(),'tmp.h5'))
}
