% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCounts.R
\name{plotCounts}
\alias{plotCounts}
\title{Create a plot with the results from epigraHMM}
\usage{
plotCounts(
  object,
  ranges,
  hdf5 = metadata(object)$output,
  peaks = NULL,
  annotation = NULL
)
}
\arguments{
\item{object}{an epigraHMMDataSet}

\item{ranges}{a GRanges object or a pair of integers with the genomic corrdinates/windows to be plotted}

\item{hdf5}{an optional character string with the hdf5 file path from `epigraHMM`}

\item{peaks}{an optional parameter with a GRanges object or a vector of logicals (with length equal to the number of rows in `object`) specifying the genomic corrdinates/windows with peaks}

\item{annotation}{an optional parameter with a GRanges object or a vector of logicals (with length equal to the number of rows in `object`) specifying the genomic corrdinates/windows of an annotation track}
}
\value{
A ggplot
}
\description{
`plotCounts()` plots read counts and peak regions from `epigraHMM()`
}
\details{
If the input object contains the assay 'offset',
reads will be normalized prior to plotting (e.g. counts/exp(offset)).
Reads from replicates pertaining to the same condition are aggregated prior to plotting.
}
\examples{

countData <- rbind(matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1),
                   matrix(rnbinom(1e3,mu = 7.5,size = 5),ncol = 1),
                   matrix(rnbinom(1e3,mu = 7.5,size = 5),ncol = 1),
                   matrix(rnbinom(1e3,mu = 2,size = 10),ncol = 1))

colData <- data.frame(condition = 'A', replicate = 1)

object <- epigraHMMDataSetFromMatrix(countData,colData)

plotCounts(object,ranges = c(500,3500))

}
\references{
\url{https://github.com/plbaldoni/epigraHMM}
}
\author{
Pedro L. Baldoni, \email{pedrobaldoni@gmail.com}
}
