% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBoxMetric.R
\name{plotBoxMetric}
\alias{plotBoxMetric}
\title{plotBoxMetric()}
\usage{
plotBoxMetric(
  rse,
  metric = "expr",
  title = "Metric",
  trans_func = function(x) x,
  ylim = NULL,
  ylab = "metric",
  palette = colorRampPalette(c("#DF536B", "black", "#61D04F"))
)
}
\arguments{
\item{rse}{a RangedSummarizedExperiment input. Aletrnatively: can be a
GRanges object (for backward compatibility).}

\item{metric}{name of the column in \code{rse} metadata containing scores.}

\item{title}{title of the plot.}

\item{trans_func}{A function to transform value of x before ploting.
Useful to apply log10 transformation
(i.e. with \code{trans_func = function(x) log10(x+1)}).}

\item{ylim}{limit of the y axis; format: \code{ylim = c(min, max)}}

\item{ylab}{y-axis title}

\item{palette}{A vector of colors, or a function that returns
a palette of \code{n} colors.}
}
\value{
Display a plot.
}
\description{
Plot distribution of a metric values as boxplots
depending of bins.
If the \code{bin} is absent from \code{gr}, a single boxplot is drawn.
}
\examples{
data("stackepi")
plotBoxMetric(
       stackepi,
       trans_func = function(x) x,
       metric = "exp",
       title = "Metric"
  )
}
