% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotEpistack.R
\name{plotEpistack}
\alias{plotEpistack}
\title{plotEpistack()}
\usage{
plotEpistack(
  rse,
  assays = NULL,
  tints = "gray",
  titles = NULL,
  legends = "",
  main = NULL,
  x_labels = c("Before", "Anchor", "After"),
  zlim = c(0, 1),
  ylim = NULL,
  metric_col = "exp",
  metric_title = "Metric",
  metric_label = "metric",
  metric_ylab = NULL,
  metric_transfunc = function(x) x,
  bin_palette = colorRampPalette(c("#DF536B", "black", "#61D04F")),
  npix_height = 650,
  n_core = 1,
  high_mar = c(2.5, 0.6, 4, 0.6),
  low_mar = c(2.5, 0.6, 0.3, 0.6),
  error_type = c("ci95", "sd", "sem"),
  reversed_z_order = FALSE,
  rel_widths = c(score = 0.35, bin = 0.08, assays = 0.35),
  rel_heights = c(1, 0.14, 0.3),
  patterns = NULL,
  ...
)
}
\arguments{
\item{rse}{a RangedSummarizedExperiment input. Aletrnatively: can be a
GRanges object
(for backward compatibility, \code{patterns} will be required).}

\item{assays}{specify the name(s) and order of assay(s) to plot. A vector of
names that should match \code{assayNames(rse)}.}

\item{tints}{a vector of colors to tint the heatmaps. Can alos be a
function returning \code{n} colors, or a list of such palette
functions.}

\item{titles}{titles of each heatmap. Defaults to \code{assays}.}

\item{legends}{legend names for the epistacks.}

\item{main}{Main title for the figure.}

\item{x_labels}{a character vector of length 3 used as x-axis labels.}

\item{zlim}{the minimum and maximum z values the heatmap.
Format: \code{zlim = c(min, max)}. \code{zlim} can also be specified of as a list of pairs of limits, on for each assay.}

\item{ylim}{limits of the y axis for bottom plots. \code{ylim} can also be specified of as a list of pairs of limits, on for each assay.
Format: \code{ylim = c(min, max)}}

\item{metric_col}{a character, name of a column in \code{gr}
such as expression value, peak height, pvalue, fold change, etc.}

\item{metric_title}{title to be display on the leftmost plots.}

\item{metric_label}{label of the leftmost plots.}

\item{metric_ylab}{y axis label of the top left plot.}

\item{metric_transfunc}{a function to transform value of \code{metric_col}
before plotting. Useful to apply log10 transformation
(i.e. with \code{trans_func = function(x) log10(x+1)}).}

\item{bin_palette}{A vector of colors, or a function that returns
a palette of \code{n} colors. Used to color
average profiles per bin in the bottom plots.}

\item{npix_height}{The matrix height is reduced to this number of rows
before plotting.
Useful to limit overplotting artefacts. It should roughtly be set to
the pixel height in the final heatmaps}

\item{n_core}{number of core used to speedup the martrix resizing.}

\item{high_mar}{a vector of numerical values
corresponding to the margins of the top figures.
c(bottom, left, top, right)}

\item{low_mar}{a vector of numerical values
corresponding to the margins of the bottom figures.
c(bottom, left, top, right)}

\item{error_type, }{error_type, can be either \code{"sd"} (standard deviation),
\code{"sem"} (standard error of the mean),
or \code{"ci95"} (95\% confidence interval). Default: \code{"ci95"}.}

\item{reversed_z_order}{For the bottom panels: should the z-order of
the curves be reversed (i.e. first or last bin on top)?}

\item{rel_widths}{A named vector of three elements of relative panel widths:
\code{score} is the left-most panel, \code{bin} is the optionnal binning panels, and
\code{assays} are the panels of the stacked-matrices.
Default to \code{c(score = .35, bin = .08, assays = .35)}}

\item{rel_heights}{A vector of three elements of relative panel heights.
Default to \code{c(1, .14, .3)}}

\item{patterns}{only if \code{rse} is of class GRanges.
A character vector of column prefixes
(can be regular expressions) that should match columns of \code{rse}.}

\item{...}{Arguments to be passed to \code{\link[graphics]{par}} such as
\code{cex}}
}
\value{
Display a plot.
}
\description{
Given a list of genomic regions,
epigenetic signals surrounding these regions, and a score for each regions,
plot epigenetic stacks depending on the score. An optional \code{bin} column
allow the grouping of several genomic regions to produce average profiles per
bins.
}
\details{
This function produce a comprehensive figure including epigenetic heatmaps
and average epigenetic profiles from a well formated
\code{RangedSummarizedExperiment} object
with expected rowData metadata columns.
It scales resonably well up to hundreds of
thousands of genomic regions.

The visualisation is centered on an anchor,
a set of genomic coordinated that can be transcription start sites or
peak center for example.
Anchor coordinates are those of the \code{GRanges}
used as a rowData in the input  RangedSummarizedExperiment object
(hereafter \code{rse}).

Anchors are plotted from top to bottom in the same order as in \code{rse}.
One should sort \code{rse} before plotting if needed.

\code{rse}'s rowData should have a metric column that is used in the
leftmost plots.
The name of the metric column must be specified to \code{metric_col}.
The metric can be transformed before plotting if needed using the
\code{metric_transfunc} parameter.

The matrix or matrices used to display the heatmap(s) should be passed as
assay(s) in \code{rse}. Such matrix can be obtained using
\code{EnrichedHeatmap::normalizeToMatrix()} for example. The assay
names are then specified through \code{assays}.

If an optionnal \code{bin} column is present in \code{rse}'s rowData,
it will be used
to group genomic regions to performed average profile per bins in the bottom
plots.

Epistack are multipanel plots build using \code{layout()}. Margins for the
panels can be specified using \code{high_mar} and \code{low_mar} parameters
if needed, especially to avoid text overlaps. The default value should
be appropriate in most situations. Individual component can be plotted
using severa \code{epistack} functions such has \code{plotStackProfile()}
or \code{plotAverageProfile()}.

Plotting more than > 1000 regions can lead to overplotting
issued as well as some plotting artefacts (such as horizontal white strips).
Both issues can be resolved with fidling with the \code{npix_height}
parameter. \code{npix_height} should be smaller than the number of regions,
and in the same order of magnitude of the final heatmap height in pixels.
Last minutes call to the \code{redimMatrix()} function will hapen before
plotting using \code{npix_height} as target height. Parameter \code{n_core}
is passed to \code{redimMatrix()} to speed up the down-scaling.

The input can also be a \code{GRanges} object for backward compatibility. See
\code{\link[epistack]{GRanges2RSE}}. \code{patterns} would then be required.
}
\examples{
data("stackepi")
plotEpistack(stackepi,
    metric_col = "exp",
    ylim = c(0, 1),
    metric_transfunc = function(x) log10(x+1))

}
\seealso{
\code{\link[epistack]{plotStackProfile}},
\code{\link[epistack]{plotAverageProfile}},
\code{\link[epistack]{redimMatrix}},
\code{\link[EnrichedHeatmap]{normalizeToMatrix}},
\code{\link[epistack]{addMetricAndArrangeGRanges}},
\code{\link[epistack]{addBins}}
}
