library(GenomicRanges)

data("stackepi")
mat1 <- SummarizedExperiment::assay(stackepi, "DNAme")

result1 <- structure(
    c(0.72759675364583, 0.702841165725677, 0.721548534230499,
      0.735401096113162, 0.659443440741914, 0.728273062571454, 0.696230718009065,
      0.710463252425579, 0.743794034911271, 0.664791869258035, 0.725700381662762,
      0.705976614039717, 0.70421313790427, 0.739815786027868, 0.672857073243013,
      0.718188100995042, 0.715164093229561, 0.705462193933419, 0.737213435923306,
      0.672695903705616, 0.717258285392787, 0.709881591023035, 0.703569668279656,
      0.741436497479916, 0.665937501310891, 0.720054940919874, 0.703521761849642,
      0.698810624381227, 0.731904604624273, 0.667853752970739, 0.716458649939956,
      0.701491086981626, 0.696665467581456, 0.721083802608203, 0.670418726637765,
      0.707814155151129, 0.703296355148587, 0.688483921620372, 0.722453976499661,
      0.672653467670759, 0.697180639651324, 0.706342844052767, 0.680867044973559,
      0.716963587225613, 0.681532907949887, 0.684954432283276, 0.702282694001674,
      0.680361474494856, 0.701782803117968, 0.690179875338481, 0.666933345250296,
      0.694610306176658, 0.68154717160184, 0.693559018419322, 0.69159915994931,
      0.649460182505801, 0.691392769548857, 0.679692527885007, 0.695064176766218,
      0.689717853508836, 0.63337213576667, 0.68127027554166, 0.670932390173998,
      0.699205776388722, 0.691515991095338, 0.609245830511688, 0.656250787140264,
      0.661788167502234, 0.705811744584612, 0.689716334614836, 0.57942013860333,
      0.633127001933916, 0.66258230169702, 0.711166921580813, 0.685521176975587,
      0.551497309793713, 0.613884337968125, 0.664113959138922, 0.710560991518395,
      0.689273667088726, 0.526313698568208, 0.584257441706977, 0.6550372003956,
      0.712915236724177, 0.692523692539414, 0.490755217869232, 0.55754535779623,
      0.648973517438484, 0.719271265063706, 0.687403404268333, 0.44775222849802,
      0.543669797283795, 0.645364573361023, 0.717090186701528, 0.677919598320624,
      0.414932625067414, 0.52694134391198, 0.634397921777716, 0.714024942242826,
      0.671263698652013, 0.38970977923859, 0.502542953602508, 0.623980753400381,
      0.713684622121231, 0.674583483219361, 0.364113755432954, 0.480949981280117,
      0.623536392681015, 0.708508750687709, 0.684607106944509, 0.345075598181567,
      0.472633407528053, 0.632837541587213, 0.707360659861182, 0.691626739543412,
      0.344065831162677, 0.468285623861412, 0.63607312963303, 0.710720416365609,
      0.688754512824369, 0.358101472231731, 0.459447423971911, 0.624278687370916,
      0.713518642000422, 0.682487412669195, 0.367056482860609, 0.4553922660587,
      0.614763527907592, 0.715011443037534, 0.68071000051138, 0.367752887396005,
      0.459809097409302, 0.613638133343187, 0.711246721444073, 0.68113885544339,
      0.359519891696158, 0.46545090792774, 0.614041807485225, 0.707307938410176,
      0.685966682800978, 0.342482944859531, 0.466601389634583, 0.614683686685314,
      0.712258200744661, 0.68709524316737, 0.338655374373739, 0.470986834011087,
      0.612940507986072, 0.717530836253603, 0.684265393145998, 0.350273243251561,
      0.470683733997704, 0.610881614077231, 0.714757595792326, 0.693881893703051,
      0.359653311894121, 0.471695526106603, 0.621277604521747, 0.714587684720483,
      0.702353438130845, 0.36878717694699, 0.490486500164326, 0.642903667170297,
      0.71948811804778, 0.695401984470813, 0.388039125405381, 0.505792668375455,
      0.654154834576414, 0.719413380439423, 0.682079356170851, 0.416998936709374,
      0.515514230712401, 0.658754738406793, 0.716144411916418, 0.678053617107541,
      0.452128285360269, 0.53898083417671, 0.671666015603273, 0.716666755865195,
      0.681721119841307, 0.494051664511149, 0.564714658507431, 0.682855804012565,
      0.714860245664726, 0.682298429744738, 0.531196720088252, 0.578370398452571,
      0.68425426504644, 0.708484816076587, 0.689895207533563, 0.550797050909322,
      0.589606035029402, 0.691536859549979, 0.706995502319839, 0.699392983564926,
      0.569113746760466, 0.605901237972808, 0.69991623072194, 0.708274809525514,
      0.699147219427675, 0.598638492040068, 0.620615919283523, 0.697541061123977,
      0.710540367808443, 0.698747202029856, 0.624452365509539, 0.632257322795722,
      0.695233328119435, 0.711536513973549, 0.705680925486714, 0.638230676139918,
      0.648110737942116, 0.697424506112515, 0.713693500016395, 0.709498905297683,
      0.648657493321727, 0.666325965378998, 0.70344935924924, 0.72612092134464,
      0.706776234383922, 0.662226380113741, 0.67833419865372, 0.710133658037259,
      0.736514817037058, 0.702778332180167, 0.679474200808893, 0.679391610364188,
      0.711154723409774, 0.734872338369098, 0.702819784075753, 0.688411064243737,
      0.68373255512783, 0.715729862486832, 0.734176850617584, 0.705213829650195,
      0.69078167420438, 0.695920036094529, 0.729744717594706, 0.745703516491626,
      0.699355265385161, 0.698926071899326, 0.705019691149343, 0.738091474127682,
      0.752630245033923, 0.69531895556956, 0.708245734664342, 0.710163961124739,
      0.733607319312592, 0.750178661578642, 0.69962500198481, 0.708347698149203,
      0.710839635509004, 0.729306456990775, 0.750619060905787, 0.697180928438094
    ), .Dim = c(5L, 51L)
)

mat2 <- matrix(
   c(1, 1, 5,
     1, 2, 3,
     0, 1, 4),
    ncol = 3, byrow = TRUE
)
result2 <- structure(c(2, 2, 2, 2, 5, 4), .Dim = 2:3)

colmat <- matrix(
    c("red", "red", "blue", "blue", "red", "blue", "blue", "green"),
    ncol = 2
)
result3 <- structure(c("#BF003FFF", "#2A2AAAFF", "#7F007FFF", "#0055AAFF"
), .Dim = c(2L, 2L))


test_that("large matrix", {
    expect_equal(
        redimMatrix(mat1, target_height = 5, target_width = ncol(mat1)),
        result1
    )
})
test_that("fail nicely", {
    expect_error(redimMatrix(mat2, target_height = 10, target_width = 5),
                 "Input matrix must be bigger than target width and height")
})
test_that("different summary function", {
    expect_equal(
        redimMatrix(mat2, target_height = 2, target_width = ncol(mat2),
                     summary_func = function(x) max(x, na.rm = TRUE)),
        result2
    )
})
test_that("works with colors", {
    expect_equal(
        redimMatrix(colmat, target_height = 2, target_width = 2,
                    summary_func = meanColor, output_type = "color"),
        result3
    )
})
