% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizChartDataMgr-class.R
\docType{class}
\name{EpivizChartDataMgr-class}
\alias{EpivizChartDataMgr-class}
\alias{EpivizChartDataMgr}
\title{Class providing data manager for epiviz charts.}
\description{
Class providing data manager for epiviz charts.
}
\section{Fields}{

\describe{
\item{\code{.ms_list}}{(environment) List of measurment records}

\item{\code{.ms_idCounter}}{(integer) Counter for ID generator}
}}

\section{Methods}{

\describe{
\item{\code{add_genome(genome)}}{Add genome to data manager (for seqInfo)
\describe{
  \item{chr}{Chromosome}
  \item{start}{Start location}
  \item{end}{End location}
}}

\item{\code{add_measurements(
  obj,
  datasource_name = NULL,
  datasource_obj_name = deparse(substitute(obj)),
  ...
)}}{Register measurements in data manager}

\item{\code{get_data(measurements, chr = NULL, start = NULL, end = NULL)}}{Get data from data mgr based on measurements, chr, start, and end
\describe{
  \item{measurements}{List of EpivizMeasurements}
  \item{chr}{Chromosome}
  \item{start}{Start location}
  \item{end}{End location}
}}

\item{\code{register_shiny_handler(session)}}{Handlers to enable interactions with Shiny session.
\describe{
  \item{session}{Shiny session object}
}}

\item{\code{rm_all_measurements()}}{Remove all registered measurements}

\item{\code{rm_measurements(ms_obj_or_id)}}{Remove registered measurements from a given data object}
}}

