% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FastQC.R
\name{FastQC}
\alias{FastQC}
\alias{atacQCReport,ATACProc-method}
\alias{atacQCReport}
\alias{qcreport}
\title{Quality control for ATAC-seq data.}
\usage{
atacQCReport(atacProc, input_file = NULL, output_file = NULL, ...)

\S4method{atacQCReport}{ATACProc}(atacProc, input_file = NULL, output_file = NULL, ...)

qcreport(input_file, output_file = NULL, ...)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacUnzipAndMerge}},
\code{\link{atacRenamer}}}

\item{input_file}{\code{Character} scalar.
Input file path. One or more(\code{vector}) fastq file path.}

\item{output_file}{\code{Character} scalar.
output file path. Defult:"input_file_QC.pdf" in the same
folder as your input file.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream
analysis.
}
\description{
Generate quality control plots from fastq of ATAC-seq data.
}
\details{
Every highthroughput sequencing need quality control analysis, this
function provide QC for ATAC-seq, such as GC content.
}
\examples{

library(R.utils)
fra_path <- system.file("extdata", "chr20_1.2.fq.bz2", package="esATAC")
fq1 <- as.vector(bunzip2(filename = fra_path,
destname = file.path(getwd(), "chr20_1.fq"),
ext="bz2", FUN=bzfile, overwrite=TRUE, remove = FALSE))
fra_path <- system.file("extdata", "chr20_2.2.fq.bz2", package="esATAC")
fq2 <- as.vector(bunzip2(filename = fra_path,
destname = file.path(getwd(), "chr20_2.fq"),
ext="bz2", FUN=bzfile, overwrite=TRUE, remove = FALSE))
\dontrun{
qcreport(input_file = c(fq1, fq2))
}


}
\seealso{
\code{\link{atacUnzipAndMerge}},
\code{\link{atacRenamer}}
}
\author{
Wei Zhang
}
