% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSSQC.R
\name{TSSQC}
\alias{TSSQC}
\alias{atacTSSQC,ATACProc-method}
\alias{atacTSSQC}
\alias{tssQC}
\title{Quality control for transcription start site(TSS) reads enrichment}
\usage{
atacTSSQC(
  atacProc,
  txdbKnownGene = NULL,
  bsgenome = NULL,
  reportPrefix = NULL,
  bedInput = NULL,
  fragLenRange = c(0, 2000),
  tssUpdownstream = 1000,
  newStepType = "TSSQC",
  ...
)

\S4method{atacTSSQC}{ATACProc}(
  atacProc,
  txdbKnownGene = NULL,
  bsgenome = NULL,
  reportPrefix = NULL,
  bedInput = NULL,
  fragLenRange = c(0, 2000),
  tssUpdownstream = 1000,
  newStepType = "TSSQC",
  ...
)

tssQC(
  bedInput,
  txdbKnownGene = NULL,
  bsgenome = NULL,
  reportPrefix = NULL,
  fragLenRange = c(0, 2000),
  tssUpdownstream = 1000,
  newStepType = "TSSQC",
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacSamToBed}},
\code{\link{atacBedUtils}}.}

\item{txdbKnownGene}{\code{TxDb} object scalar.
TxDb object for specific species.}

\item{bsgenome}{\code{BSGenome} object scalar.
BSGenome object for specific species.}

\item{reportPrefix}{\code{Character} scalar.
The prefix of report files path.}

\item{bedInput}{\code{Character} scalar.
BED file input path.}

\item{fragLenRange}{\code{Interger} vector of 2 element.
The fragment length ranges.}

\item{tssUpdownstream}{\code{Interger} scalar.
The upstream and downstrem from TSS locations.}

\item{newStepType}{\code{Character} scalar.
New class name}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
These functions are used to generate the reads coverage plot around TSS.
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
\code{atacProc} should be set \code{NULL}
or you can use \code{tssQC} instead.
}
\examples{
library(R.utils)
td <- tempdir()
setTmpDir(td)

bedbzfile <- system.file(package="esATAC", "extdata", "chr20.50000.bed.bz2")
bedfile <- file.path(td,"chr20.50000.bed")
bunzip2(bedbzfile,destname=bedfile,overwrite=TRUE,remove=FALSE)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
library(BSgenome.Hsapiens.UCSC.hg19)
tssQC(bedfile,TxDb.Hsapiens.UCSC.hg19.knownGene,BSgenome.Hsapiens.UCSC.hg19,fragLenRange=c(180,247))

dir(td)
}
\seealso{
\code{\link{atacSamToBed}}
\code{\link{samToBed}}
\code{\link{atacBedUtils}}
\code{\link{bedUtils}}
}
\author{
Zheng Wei
}
