% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsAnalysis.R
\name{plotMetricsClusterComparison}
\alias{plotMetricsClusterComparison}
\title{Comparison between two clusterings as plot.
plotMetricsClusterComparison}
\usage{
plotMetricsClusterComparison(data, k.vector1, k.vector2 = NULL,
  seed = NULL)
}
\arguments{
\item{data}{A \code{\link{SummarizedExperiment}}.
The SummarizedExperiment must contain an assay with the following structure:
A valid header with names. The first  column of the header is the ID or name
of the instance of the dataset (e.g., ontology, pathway, etc.) on which the
metrics are measured.
The other columns of the header contains the names of the metrics.
The rows contains the measurements of the metrics for each instance in the dataset.}

\item{k.vector1}{Vector of positive integers representing \code{k} clusters.
The \code{k} values must be contained in [2,15] range.}

\item{k.vector2}{Optional. Vector of positive integers representing \code{k} clusters.
The \code{k} values must be contained in [2,15] range.}

\item{seed}{Positive integer. A seed for internal bootstrap.}
}
\value{
Nothing.
}
\description{
It plots a clustering comparison between two different
k-cluster vectors for a set of metrics.
}
\examples{
# Using example data from our package
data("rnaMetrics")
stabilityData <- stabilityRange(data=rnaMetrics, k.range=c(2,4), bs=20, getImages = FALSE)
qualityData <- qualityRange(data=rnaMetrics, k.range=c(2,4), getImages = FALSE)
kOptTable = getOptimalKValue(stabilityData, qualityData)


}
