% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAssayDensities.R
\name{plotAssayDensities}
\alias{plotAssayDensities}
\alias{plotAssayDensities,SummarizedExperiment-method}
\title{Plot Densities for any assay within a SummarizedExperiment}
\usage{
plotAssayDensities(x, ...)

\S4method{plotAssayDensities}{SummarizedExperiment}(
  x,
  assay = "counts",
  group = NULL,
  colour = NULL,
  fill = NULL,
  linetype = NULL,
  linewidth = NULL,
  alpha = NULL,
  trans = NULL,
  n_max = Inf,
  ...
)
}
\arguments{
\item{x}{A SummarizedExperiment object}

\item{...}{Passed to \link[ggplot2]{geom_density}}

\item{assay}{An assay within x}

\item{group}{Used by \link[ggplot2]{geom_line}. Defaults to the column names
but treatment groups can also be specified to summarise within groups}

\item{colour, fill, alpha}{Optional column in colData to set the respective
aesthetics. Can also be any valid colour specification as a fixed value or
a fixed alpha value}

\item{linetype, linewidth}{Any optional column in colData used to determine
linetype or linewidth. Can also be fixed values}

\item{trans}{character(1). Any transformative function to be applied to the
data before calculating the density, e.g. \code{trans = "log2"}}

\item{n_max}{Maximum number of points to use when calculating densities}
}
\value{
A \code{ggplot2} object. Scales and labels can be added using conventional
\code{ggplot2} syntax.
}
\description{
Plot Densities for any assay within a SummarizedExperiment
}
\details{
Uses ggplot2 to create a density plot for all samples within the selected
assay
}
\examples{
data("se")
se$treatment <- c("E2", "E2", "E2", "E2DHT", "E2DHT", "E2DHT")
## Plot individual samples
plotAssayDensities(se, colour = "treatment")
## Plot combined within treatment groups
plotAssayDensities(se, colour = "treatment", group = "treatment")
## Use a data transformation
plotAssayDensities(se, trans = "log1p", colour = "treat")

}
