% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgseaORA.R
\name{fora}
\alias{fora}
\title{Simple overrepresentation analysis based on hypergeometric test}
\usage{
fora(pathways, genes, universe, minSize = 1, maxSize = length(universe) - 1)
}
\arguments{
\item{pathways}{List of gene sets to check.}

\item{genes}{Set of query genes}

\item{universe}{A universe from whiche `genes` were selected}

\item{minSize}{Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{maxSize}{Maximal size of a gene set to test. All pathways above the threshold are excluded.}
}
\value{
A table with ORA results. Each row corresponds to a tested pathway.
The columns are the following:
\itemize{
 \item pathway -- name of the pathway as in `names(pathway)`;
 \item pval -- an enrichment p-value from hypergeometric test;
 \item padj -- a BH-adjusted p-value;
 \item foldEnrichment -- degree of enrichment relative to background;
 \item overlap -- size of the overlap;
 \item size -- size of the gene set;
 \item leadingEdge -- vector with overlapping genes.
}
}
\description{
Simple overrepresentation analysis based on hypergeometric test
}
\examples{
data(examplePathways)
data(exampleRanks)
foraRes <- fora(examplePathways, genes=tail(names(exampleRanks), 200), universe=names(exampleRanks))
}
