% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{EHtrans-class}
\alias{EHtrans-class}
\alias{EHtrans}
\alias{eval,EHtrans,missing-method}
\title{Class "EHtrans"}
\description{
EH transformation of a parameter is defined by the function
\deqn{EH(parameter,a,b)= 10^{(\frac{parameter}{a})} +
\frac{b*parameter}{a}-1, parameter>=0}
\deqn{-10^{(\frac{-parameter}{a})} + \frac{b*parameter}{a}+1, parameter<0}
}
\section{Slots}{

\describe{
\item{\code{.Data}}{Object of class \code{"function"}.}

\item{\code{a}}{Object of class \code{"numeric"} -- numeric constant greater than zero.}

\item{\code{b}}{Object of class \code{"numeric"} -- numeric constant greater than zero.}

\item{\code{parameters}}{Object of class \code{"transformation"} -- flow parameter to be 
transformed.}

\item{\code{transformationId}}{Object of class \code{"character"} -- unique ID to reference the transformation.}
}}

\note{
The transformation object can be evaluated using the eval method by
passing the data frame as an argument.The transformed parameters are
returned as a matrix with a single column. (See example below)
}
\section{Objects from the Class}{
 Objects can be created by calls to the
constructor \code{EHtrans(parameters,a,b,transformationId)}
}

\section{Extends}{

Class \code{"\linkS4class{singleParameterTransform}"}, directly.

Class \code{"\linkS4class{transform}"}, by class "singleParameterTransform", distance 2.

Class \code{"\linkS4class{transformation}"}, by class "singleParameterTransform", distance 3.

Class \code{"\linkS4class{characterOrTransformation}"}, by class "singleParameterTransform", distance 4.
}

\examples{

  dat <- read.FCS(system.file("extdata","0877408774.B08",
                  package="flowCore"))
  eh1<-EHtrans("FSC-H",a=1250,b=4,transformationId="eh1")
  transOut<-eval(eh1)(exprs(dat))

}
\references{
Gating-ML Candidate Recommendation for Gating Description in
Flow Cytometry V 1.5
}
\seealso{
hyperlog

Other mathematical transform classes: 
\code{\link{asinht-class}},
\code{\link{asinhtGml2-class}},
\code{\link{dg1polynomial-class}},
\code{\link{exponential-class}},
\code{\link{hyperlog-class}},
\code{\link{hyperlogtGml2-class}},
\code{\link{invsplitscale-class}},
\code{\link{lintGml2-class}},
\code{\link{logarithm-class}},
\code{\link{logicletGml2-class}},
\code{\link{logtGml2-class}},
\code{\link{quadratic-class}},
\code{\link{ratio-class}},
\code{\link{ratiotGml2-class}},
\code{\link{sinht-class}},
\code{\link{splitscale-class}},
\code{\link{squareroot-class}},
\code{\link{unitytransform-class}}
}
\author{
Gopalakrishnan N, F.Hahne
}
\concept{mathematical transform classes}
\keyword{classes}
