% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowFrame-accessors.R
\name{transform}
\alias{transform}
\alias{transform,flowFrame-method}
\alias{transform,flowSet-method}
\title{Transform a flowFrame or flowSet}
\usage{
\S4method{transform}{flowFrame}(`_data`, translist, ...)
}
\arguments{
\item{_data}{a flowFrame or flowSet object}

\item{translist}{a transformList object}

\item{...}{other arguments. e.g. `FL1-H` = myFunc(`FL1-H`)}
}
\description{
Similar to the base transform method, this will transform the values of
a flowFrame or flowSet object according to the transformations specified
in one of two ways:
1. a [transformList][flowCore::transformList-class] or list of [transform][flowCore::transform-class] objects
2. named arguments specifying transformations to be applied to channels (see details)
}
\details{
To specify the transformations in the second way, the names of these arguments 
should correspond to the new channel names and the values should be functions applied to
channels currently present in the flowFrame or flowSet. There are a few examples below.
}
\examples{
data(GvHD)
# logarithmically transform FL1-H and FL2-H for the entire flowSet
# using a transformList
fs <- transform(GvHD,
                 transformList(c("FL1-H", "FL2-H"), list(log, log)))
                 
# transform a single flowFrame using named arguments. Note the first
# transformation will overwrite FL1-H while the second will create a new
# channel 
fr <- transform(GvHD[[1]],
                 `FL1-H`=log(`FL1-H`),
                 `logFL2`=log(`FL2-H`))


}
