% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_accessors.R
\name{fg_get_graph}
\alias{fg_get_graph}
\title{Retrieves a graph list from a given flowGraph object.}
\usage{
fg_get_graph(fg)
}
\arguments{
\item{fg}{flowGraph object.}
}
\value{
A list containing two data frames (\code{v} and ]code{e})
 from the \code{graph} slot of the given \code{flowGraph} object containing
 information on the cell populations phenotype nodes and edges representing
 relation between cell populations.
}
\description{
Retrieves a graph list from a given flowGraph object.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)
 gr <- fg_get_graph(fg)
 head(gr$v)
 head(gr$e)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_plot}}
 \code{\link[flowGraph]{ggdf}}
 \code{\link[flowGraph]{plot_gr}}
}
