% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{qaGating}
\alias{qaGating}
\title{Quality assurance check}
\usage{
qaGating(x, threshold = 100)
}
\arguments{
\item{x}{\code{flowSet} or \code{flowFrame} to be checked}

\item{threshold}{\code{flowFrames} with fewer events than this threshold
will be identified.}
}
\value{
A vector containing the \code{flowFrames} with fewer events than
the threshold.
}
\description{
Check whether a flowSet (or a single flowFrame) contains empty
values, in which case normalization may fail (divide by zero). This is
particularly useful for removing wash wells from a flowSet.
}
\examples{
plate1<-read.flowSet(path = system.file("extdata", "ss_example", package =
"flowTime"), alter.names = TRUE)
qaGating(plate1)

}
