% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytoframe.R, R/cytoset.R,
%   R/GatingHierarchy_Methods.R, R/GatingSet_Methods.R
\name{cleanup_temp}
\alias{cleanup_temp}
\alias{cf_cleanup_temp}
\alias{cs_cleanup_temp}
\alias{gh_cleanup_temp}
\alias{gs_cleanup_temp}
\title{Remove temporary files associatated with flowWorkspace data classes}
\usage{
cf_cleanup_temp(x, temp_dir = NULL)

cs_cleanup_temp(x, temp_dir = NULL)

gh_cleanup_temp(x, temp_dir = NULL)

gs_cleanup_temp(x, temp_dir = NULL)
}
\arguments{
\item{x}{a cytoframe, cytoset, GatingHierarchy, or GatingSet object}

\item{temp_dir}{an optional argument designating another path as temporary storage. If specified
this will override tempdir() in determining the top directory under which files can safely be removed.}
}
\description{
These methods immediately delete the on-disk h5 storage associated with \link{cytoframe},
\link{cytoset}, \linkS4class{GatingHierarchy}, or \linkS4class{GatingSet} objects, but only if it is
under the directory pointed to by tempdir() or alternatively specified by the temp_dir option.
The temp_dir option should be used with caution as it acts as a guard against accidental
removal of non-temporary storage.
}
\details{
Use of these functions will generally be unnecessary for most users, but they are provided
for workflows that involve repeated creation of such data structures within the same R session
to avoid overwhelming temporary storage.
}
