% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copyNode.R
\name{gh_copy_gate}
\alias{gh_copy_gate}
\alias{copyNode}
\title{Copy a node along with all of its descendant nodes to the given ancestor}
\usage{
gh_copy_gate(gh, node, to)
}
\arguments{
\item{gh}{GatingHierarchy}

\item{node}{the node to be copied}

\item{to}{the new parent node under which the \code{node} will be copied}
}
\description{
Copy a node along with all of its descendant nodes to the given ancestor
}
\examples{
library(flowWorkspace)
dataDir <- system.file("extdata",package="flowWorkspaceData")
suppressMessages(gs <- load_gs(list.files(dataDir, pattern = "gs_manual",full = TRUE)))
gh <- gs[[1]]
old.parent <- gs_pop_get_parent(gh, "CD4")
new.parent <- "singlets"
gh_copy_gate(gh, "CD4", new.parent)
gs_get_pop_paths(gh)
}
