% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_GatingSet.R
\name{gs_check_redundant_nodes}
\alias{gs_check_redundant_nodes}
\alias{checkRedundantNodes}
\title{try to determine the redundant terminal(or leaf) nodes that can be removed}
\usage{
gs_check_redundant_nodes(x, path = "auto", ...)
}
\arguments{
\item{x}{\code{GatingSet} or \code{list} of groups(each group is a list of 'GatingSet`). When it is a list, it is usually the outcome from \link{gs_split_by_tree}.}

\item{path}{argumented passed to \link{gs_get_pop_paths}. The default value is "auto".}

\item{...}{other arguments passed to \link{gs_get_pop_paths}.}
}
\value{
a list of the character vectors inicating the nodes that are considered to be redundant for each group of GatingSets.
}
\description{
These leaf nodes make the gating trees to be different from one another and can be removed by the subsequent convevient call 
\link{gs_remove_redundant_nodes}.
}
\examples{
\dontrun{
gslist <- list(gs1, gs2, gs3, gs4, gs5)
gs_groups <- gs_split_by_tree(gslist)
toRm <- gs_check_redundant_nodes(gs_groups)
}
}
