% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msea.R
\name{msea}
\alias{msea}
\title{Performs a preranked metabolite set enrichment analysis (MSEA)}
\usage{
msea(
  metaboliteRanks,
  subOntology = "food",
  pvalCutoff = 0.01,
  fobi = fobitools::fobi
)
}
\arguments{
\item{metaboliteRanks}{A named vector of FOBI metabolite identifiers with their metabolite-level stats.}

\item{subOntology}{A character string specifying one of the two FOBI sub-ontologies: "food", or "biomarker".}

\item{pvalCutoff}{A numeric value indicating a p-value cutoff for raw p-values generated by MSEA.}

\item{fobi}{FOBI table obtained with `parse_fobi()`. If this value is set to NULL, the last version of FOBI will be downloaded from GitHub.}
}
\value{
A tibble with MSEA results.
}
\description{
This function performs a MSEA based on the adaptive multilevel splitting Monte Carlo approach.
}
\examples{

metabolites <- c(fobitools::idmap$FOBI[1:49], fobitools::idmap$FOBI[70:80])
random_pvals <- c(runif(n = length(metabolites)*0.3, min = 0.001, max = 0.05), runif(n = length(metabolites)*0.7, min = 0.05, max = 0.99))
names(random_pvals) <- metabolites
metaboliteRanks <- random_pvals[order(random_pvals)]

# Food enrichment analysis
fobitools::msea(metaboliteRanks = metaboliteRanks, 
                pvalCutoff = 1)

# Chemical class enrichment analysis
fobitools::msea(metaboliteRanks = metaboliteRanks, 
                subOntology = "biomarker", 
                pvalCutoff = 1)

}
\references{
G. Korotkevich, V. Sukhov, A. Sergushichev. Fast gene set enrichment analysis. bioRxiv (2019), doi:10.1101/060012

Pol Castellano-Escuder, Raúl González-Domínguez, David S Wishart, Cristina Andrés-Lacueva, Alex Sánchez-Pla, FOBI: an ontology to represent food intake data and associate it with metabolomic data, Database, Volume 2020, 2020, baaa033, https://doi.org/10.1093/databa/baaa033.
}
\author{
Pol Castellano-Escuder
}
