% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization.R
\name{ct.normalizeMedians}
\alias{ct.normalizeMedians}
\title{Normalize sample abundance estimates by median gRNA counts}
\usage{
ct.normalizeMedians(eset, lib.size = NULL)
}
\arguments{
\item{eset}{An \code{ExpressionSet} containing, at minimum, count data accessible by \code{exprs}.}

\item{lib.size}{An optional vector of voom-appropriate library size adjustment factors, usually calculated with \code{\link[edgeR]{calcNormFactors}} 
and transformed to reflect the appropriate library size. These adjustment factors are interpreted as the total library sizes for each sample, 
and if absent will be extrapolated from the columnwise count sums of the \code{exprs} slot of the \code{eset}.}
}
\value{
A renormalized ExpressionSet object of the same type as the provided object.
}
\description{
This function normalizes Crispr gRNA abundance estimates by equalizing the median gRNA abundance values after
correcting for library size. It does this by converting raw count values to log2 counts per million and optionally adjusting further in 
the usual way by dividing these values by user-specified library size factors. THis method should be more stable than the endogenous 
scaling functions used in \code{voom} in th especific case of Crispr screens or other cases where the median number of observed counts may be low.
}
\examples{
data('es')

#Build the sample key and library sizes for visualization
library(Biobase)
sk <- ordered(relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference'))
names(sk) <- row.names(pData(es))
ls <- colSums(exprs(es))

es.norm <- ct.normalizeMedians(es, lib.size= ls)
ct.gRNARankByReplicate(es, sampleKey = sk, lib.size= ls)
ct.gRNARankByReplicate(es.norm, sampleKey = sk, lib.size= ls)
}
\author{
Russell Bainer
}
