% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileutilities.R
\name{ct.resultCheck}
\alias{ct.resultCheck}
\title{Determine whether a supplied object contains the results of a Pooled Screen}
\usage{
ct.resultCheck(summaryDF)
}
\arguments{
\item{summaryDF}{A \code{data.frame}, usually returned by \code{ct.generateResults}. 
if you need to generate one of these by hand for some reason, see the example 
\code{resultsDF} object loaded in the example below.}
}
\value{
A logical indicating whether the object is of the appropriate format.
}
\description{
Many gCrisprTools functions operate on a \code{data.frame} of results
generated by a CRISPR screen. This function takes in a supplied object and returns 
a logical indicating whether the object can be treated as one of these data.frames 
for the purposes of downstream analyses. This is largely used internally, but can 
be useful if a user needs to build a result object for some reason.
}
\examples{
data('resultsDF')
ct.resultCheck(resultsDF)
}
\author{
Russell Bainer
}
