% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrastScatter.R
\name{ct.scatter}
\alias{ct.scatter}
\title{Compare Two CRISPR Screen Contrasts via a Scatter Plot}
\usage{
ct.scatter(
  dflist,
  targets = c("geneSymbol", "geneID"),
  statistic = c("best.p", "best.q"),
  cutoff = 0.05,
  plot.it = TRUE
)
}
\arguments{
\item{dflist}{A (named) list of results dataframes, of length 2. See \code{\link{ct.generateResults}}.}

\item{targets}{Column of the provided \code{summaryDF} to consider. Must be \code{geneID} or \code{geneSymbol}.}

\item{statistic}{Statistic to plot on each axis (after -log10 transformation). Must be 'p', 'q', or 'rho'.}

\item{cutoff}{significance cutoff used to define the significance quadrants (cannot be exactly zero).}

\item{plot.it}{Logical indicating whether to compose the plot on the default device.}
}
\value{
Invisibly, a list of length 4 containing the genes passing significance for the respective quadrants.
}
\description{
This is a function for comparing the results of two screening experiments. Given two \code{summaryDF}, 
the function places them in register with one another, generates a simplified scatter plot where enrichment or depletion 
in each contrast is represented by the associated "signed" log10 (*P*/*Q*)-value (where enriched signals are represented 
in the positive direction and depleted signals are shown in the negative direction), and returns an invisible `data.frame`
containing the target X-axis and Y-axis coordinates and corresponding quadrant. 

This is a target-level analysis, and some minor simplifications are introduced to screen signals for the sake of clarity. 
Principal among these is the decision to collapse gene signals to a single directional enrichment statistic. Target-level
signals are typically aggregates of many guide-level signals, it is formally possible for targets to be both significantly 
enriched and significantly depleted within a single screen contrast as a result of substantially divergent reagent activity. 
This behavior is uncommon, however, and so targets are represented by selecting the direction of enrichment or depletion 
associated with the most significant (*P*/*Q*)-value. This directionality is then encoded into the X-axis and Y-axis 
position of the target as the sign of the signal as described above.
}
\examples{
data('resultsDF')
scat <- ct.scatter(list('FirstResult' = resultsDF[100:2100,], 'SecondResult' = resultsDF[1:2000,]))
head(scat)
}
\author{
Russell Bainer
}
