% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{annotate_se_with_drug}
\alias{annotate_se_with_drug}
\title{annotate_se_with_drug}
\usage{
annotate_se_with_drug(se, drug_annotation, fill = "unknown")
}
\arguments{
\item{se}{SummarizedExperiment object containing dose-response data}

\item{drug_annotation}{data.table with drug annotations}

\item{fill}{string indicating how unknown drugs should be filled in the DB}
}
\value{
SummarizedExperiment object with annotated drugs
}
\description{
Annotate SummarizedExperiment object with drug annotations
}
\examples{
se <- SummarizedExperiment::SummarizedExperiment(
  rowData = data.table::data.table(Gnumber = c("D1", "D2", "D3"))
)
drug_annotation <- get_drug_annotation(data.table::as.data.table(SummarizedExperiment::rowData(se)))
annotated_se <- annotate_se_with_drug(se, drug_annotation)
}
\keyword{annotation}
