% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_SE.combinations.R
\name{fit_SE.combinations}
\alias{fit_SE.combinations}
\title{fit_SE for combination screens}
\usage{
fit_SE.combinations(
  se,
  data_type = gDRutils::get_supported_experiments("combo"),
  series_identifiers = NULL,
  normalization_types = c("GR", "RV"),
  averaged_assay = "Averaged",
  metrics_assay = "Metrics",
  score_FUN = calculate_score
)
}
\arguments{
\item{se}{\code{SummarizedExperiment} object with a BumpyMatrix assay
containing averaged data.}

\item{data_type}{single-agent vs combination}

\item{series_identifiers}{character vector of the column names in the
nested \code{DFrame} corresponding to nested identifiers.}

\item{normalization_types}{character vector of normalization types used for
calculating combo matrix.}

\item{averaged_assay}{string of the name of the averaged assay to use as
input. in the \code{se}.}

\item{metrics_assay}{string of the name of the metrics assay to output
in the returned \linkS4class{SummarizedExperiment}.
whose combination represents a unique series for which to fit curves.}

\item{score_FUN}{function used to calculate score for HSA and Bliss}
}
\value{
A \code{SummarizedExperiment} object with an additional assay
containing the combination metrics.
}
\description{
Perform fittings for combination screens.
}
\details{
This function assumes that the combination is set up with both
concentrations nested in the assay.
}
\examples{
fmae_cms <- gDRutils::get_synthetic_data("finalMAE_combo_matrix_small")

se1 <- fmae_cms[[gDRutils::get_supported_experiments("combo")]]
SummarizedExperiment::assays(se1) <- 
  SummarizedExperiment::assays(se1)["Averaged"]
fit_SE.combinations(se1[1, 1])

}
\keyword{runDrugResponseProcessingPipeline}
