% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicates.R
\name{get_assay_dt_duplicated_rows}
\alias{get_assay_dt_duplicated_rows}
\title{Helper function to find duplicated rows in assay data}
\usage{
get_assay_dt_duplicated_rows(dt, output = "index")
}
\arguments{
\item{dt}{data.table}

\item{output}{string with the output format to be returned}
}
\value{
integer vector or data.table with duplicated rows
}
\description{
Helper function to find duplicated rows in assay data
}
\examples{
sdata <- get_synthetic_data("finalMAE_small")
smetrics_data <- convert_se_assay_to_dt(sdata[[1]], "Metrics")
get_assay_dt_duplicated_rows(smetrics_data, output = "data")
get_assay_dt_duplicated_rows(smetrics_data)
}
\keyword{duplicates}
