% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{exportSEA}
\alias{exportSEA}
\title{Export CondSEA or PathSEA results to XLS format}
\usage{
exportSEA(rp, results, outname = NULL)
}
\arguments{
\item{rp}{A repository created by \code{\link{createRepository}}.}

\item{results}{The output of \code{CondSEA} or \code{PathSEA}.}

\item{outname}{Name of the XLS file to be created.}
}
\value{
Nothing.
}
\description{
The XLS output includes the full CondSEA or PathSEA results,
together with additional gene set information for the CondSEA. If
the PathSEA or CondSEA analysis was performed with
\code{details=TRUE}, details will be reported in the XLS file. This
function requires the WriteXLS library.
}
\examples{

db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)
geps <- loadSampleGEP()
buildPEPs(rp, geps)

pgset <- c("(+)_chelidonine", "(+/_)_catechin")
psea <- CondSEA(rp, pgset)

\dontrun{
exportSEA(rp, psea)
}

unlink(repo_path, TRUE)

}
\seealso{
CondSEA, PathSEA
}
