% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{openRepository}
\alias{openRepository}
\title{Opens an existing repository of pathway collections.}
\usage{
openRepository(path)
}
\arguments{
\item{path}{Path to a directory where the repository has been
created with \code{\link{createRepository}}.}
}
\value{
An object of class \code{repo} that can be passed to
    \code{gep2pep} functions.
}
\description{
The repository must have been created by
\code{\link{createRepository}}. Provides an R object to interact
with the repository.
}
\details{
This function only calls the \code{repo_open} function
    from the \code{repo} package on \code{path}. It is meant to
    allow users not to explicitly load the \code{repo} library,
    unless they want to access advanced features.
}
\examples{

db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)
rp2 <- openRepository(repo_path)

## rp and rp2 point to the same data:
identical(rp$entries(), rp2$entries())
## > [1] TRUE

unlink(repo_path, TRUE)
}
\seealso{
createRepository
}
