% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{geva.input.correct}
\alias{geva.input.correct}
\alias{geva.input.filter}
\alias{geva.input.rename.rows}
\title{GEVA Input Post-processing}
\usage{
geva.input.correct(ginput, na.rm = TRUE, inf.rm = TRUE, invalid.col.rm = TRUE)

geva.input.filter(
  ginput,
  p.value.cutoff = 0.05,
  by.any = FALSE,
  na.val = 0,
  ...
)

geva.input.rename.rows(
  ginput,
  attr.column,
  dupl.rm.method = c("least.p.vals", "order")
)
}
\arguments{
\item{ginput}{A \code{\linkS4class{GEVAInput}} object}

\item{na.rm}{\code{logical}; if \code{TRUE}, removes all rows containing \code{NA}}

\item{inf.rm}{\code{logical}; if \code{TRUE}, removes all rows containing infinite values (\code{Inf} or \code{-Inf})}

\item{invalid.col.rm}{\code{logical}; if \code{TRUE}, searches for any column that is entirely composed by invalid values (according to the other arguments) and removes it before checking the rows}

\item{p.value.cutoff}{\code{numeric} (\code{0} to \code{1}), the p-value cutoff. Rows containing values above this threshold are removed}

\item{by.any}{\code{logical}, set to \code{TRUE} to delete the rows with at least one occurrence above the cutoff; or \code{FALSE} to delete only those rows in which all values are above the specified threshold}

\item{na.val}{\code{numeric}, the replacement for \code{NA} values}

\item{...}{optional arguments. Accepts \code{verbose} (\code{logical}, default is \code{TRUE}) to enable or disable printing the progress}

\item{attr.column}{\code{character}, target column with the values that will replace the current row names}

\item{dupl.rm.method}{\code{character}, method to remove duplicate names. The possible options are:
\itemize{
\item{\code{"least.p.vals"} : Keeps the duplicate that contains the least sum of p-values}
\item{\code{"order"} : Keeps the first occurrence of the duplicate in the current row order}
}}
}
\value{
A modified \code{\linkS4class{GEVAInput}} object
}
\description{
Helper functions used to edit the contents from a \code{\linkS4class{GEVAInput}}.
}
\details{
\code{geva.input.correct} corrects the numeric input data (values and weights), removing rows that include invalid values such as NA or infinite.

\code{geva.input.filter} attempts to select the most relevant part of the input data, removing rows containing p.values (1 - weights) above a specific threshold.

\code{geva.input.rename.rows} replaces the row names with a column from the feature table (see \code{\linkS4class{GEVAInput}}). The column name specified for \code{attr.column} must be included in the \code{names(featureTable(ginput))}. Any duplicates are removed according to the \code{dupl.rm.method}, and the selected duplicates are stored as a new column named \code{"renamed_id"} inside the feature table from the returned object.
}
\examples{
## geva.input.correct example
colexample1 <- runif(1000, -1, 1)        # Random column 1
colexample2 <- runif(1000, -1, 1)        # Random column 2
colexample3 <- runif(1000, -1, 1)        # Random column 3
colexample3[runif(1000, -1, 1) < 0] = NA # Random NA's
ginput = geva.merge.input(col1=colexample1,
                          col2=colexample2,
                          col3=colexample3)
# Before the correction:
print(nrow(ginput))    # Returns 1000
# Applies the correction (removes rows with NA's)
ginput <- geva.input.correct(ginput)
# After the correction:
print(nrow(ginput))    # Returns less than 1000

## ---
## geva.input.filter example
ginput <- geva.ideal.example(1000)  # Generates a random input
# Before the filter:
print(nrow(ginput))    # Returns 1000
# Applies the filter
ginput <- geva.input.filter(ginput)
# After the filter:
print(nrow(ginput))    # Returns less than 1000

## ---
## geva.input.rename.rows example
ginput <- geva.ideal.example()  # Generates a random input
# Renames to 'Symbol'
ginput <- geva.input.rename.rows(ginput,
                                 attr.column = "Symbol")
print(head(ginput))             # The row names are set now as the gene symbols

}
