% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcyto.R
\name{as.ggplot}
\alias{as.ggplot}
\title{It fortifies the data, fills some default settings and returns a regular ggplot object.}
\usage{
as.ggplot(x, pre_binning = FALSE)
}
\arguments{
\item{x}{ggcyto object with the data that has not yet been fortified to data.frame.}

\item{pre_binning}{whether to pass the binned data to ggplot to avoid the overhead to scaling the original raw data for geom_hex layer}
}
\value{
ggplot object
}
\description{
The orginal data format is preserved during the ggcyo constructor because they still need to be used during the plot building process.
This function is usually called automatically in the print/plot method of ggycyto. Sometime it is useful to coerce it to ggplot explictily
by user so that it can be used as a regular ggplot object.
}
\examples{
data(GvHD)
fs <- GvHD[1:3]
#construct the `ggcyto` object (inherits from `ggplot` class)
p <- ggcyto(fs, aes(x = `FSC-H`)) + geom_histogram() 
class(p) # a ggcyto object
p$data # data has not been fortified
p1 <- as.ggplot(p) # convert it to a ggplot object explictily 
class(p1) 
p1$data # data is fortified
}
