% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_stats.R
\name{compute_stats}
\alias{compute_stats}
\title{compute the statistics of the cell population defined by gates}
\usage{
compute_stats(fs = NULL, gates, type = "percent", value = NULL, ...)
}
\arguments{
\item{fs}{flowSet. can be NULL when precaculated 'value' is provided}

\item{gates}{a list of filters}

\item{type}{a vector of strings to specify the stats types. can be any or multiple values of "percent", "count", "gate_name", or "MFI" (MFI is currently not supported yet).}

\item{value}{the pre-calculated stats value. when supplied, the stats computing is skipped.}

\item{...}{other arguments passed to stat_position function}
}
\value{
a data.table that contains percent and centroid locations as well as pData
that used as data for geom_btext layer.
}
\description{
It calls the underlining stats routine and merge it with the label position calculated by stat_position
as well as the pData of flowSet.
}
\details{
This function is usually not called directly by user but used by ggcyto when geom_stat layer is added.
}
\examples{
data(GvHD)
fs <- GvHD[1:4]
rect.g <- rectangleGate(list("FSC-H" =  c(300,500), "SSC-H" = c(50,200)), filterId = "P1")
rect.gates <- sapply(sampleNames(fs), function(sn)rect.g)
compute_stats(fs, rect.gates)
compute_stats(fs, rect.gates, type = c("gate_name", "percent"))
}
