% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc-dim-utilities.R
\name{sc_dim_geom_ellipse}
\alias{sc_dim_geom_ellipse}
\title{sc_dim_geom_ellipse}
\usage{
sc_dim_geom_ellipse(geom = stat_ellipse, mapping = NULL, level = 0.95, ...)
}
\arguments{
\item{geom}{the layer function, default is \code{stat_ellipse},
other option is \code{geom_mark_hull} of \code{ggforce}.}

\item{mapping}{aesthetic mapping}

\item{level}{the level at which to draw an ellipse}

\item{...}{additional parameters pass to the stat_ellipse}
}
\value{
layer of ellipse
}
\description{
sc_dim_geom_ellipse
}
\examples{
library(scuttle)
library(scater)
library(scran)
library(ggplot2)
sce <- mockSCE()
sce <- logNormCounts(sce)
clusters <- clusterCells(sce, assay.type = 'logcounts')
colLabels(sce) <- clusters
sce <- runUMAP(sce, assay.type = 'logcounts')
p1 <- sc_dim(sce, reduction = 'UMAP', mapping = aes(colour = Cell_Cycle))
p2 <- sc_dim(sce, reduction = 'UMAP')
f1 <- p1 + sc_dim_geom_ellipse()
}
\seealso{
\link[ggplot2:stat_ellipse]{stat_ellipse};
}
