% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position_jitterdodgex.R
\name{position_jitterdodgex}
\alias{position_jitterdodgex}
\title{Simultaneously dodge and jitter, and the whole layer can be shifted vertically or horizontally}
\usage{
position_jitterdodgex(
  jitter.width = NULL,
  jitter.height = 0,
  dodge.width = 0.75,
  hexpand = NA,
  vexpand = NA,
  seed = NA
)
}
\arguments{
\item{jitter.width}{degree of jitter in x direction. Defaults to 40\% of the
resolution of the data.}

\item{jitter.height}{degree of jitter in y direction. Defaults to 0.}

\item{dodge.width}{the amount to dodge in the x direction. Defaults to 0.75,
the default \code{position_dodge()} width.}

\item{hexpand, vexpand}{The distance to be shifted vertically or horizontally,
default is NA.}

\item{seed}{A random seed to make the jitter reproducible.
Useful if you need to apply the same jitter twice, e.g., for a point and
a corresponding label.
The random seed is reset after jittering.
If \code{NA} (the default value), the seed is initialised with a random value;
this makes sure that two subsequent calls start with a different seed.
Use \code{NULL} to use the current random seed and also avoid resetting}
}
\description{
This is primarily used for aligning points generated through
'geom_point()' with dodged boxplots (e.g., a 'geom_boxplot()' with
a fill aesthetic supplied). And the points can be shifted vertically
or horizontally with 'hexpand' or 'vexpand' arguments.
}
