% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtree.R
\name{ggtree}
\alias{ggtree}
\title{ggtree}
\usage{
ggtree(
  tr,
  mapping = NULL,
  layout = "rectangular",
  open.angle = 0,
  mrsd = NULL,
  as.Date = FALSE,
  yscale = "none",
  yscale_mapping = NULL,
  ladderize = TRUE,
  right = FALSE,
  branch.length = "branch.length",
  root.position = 0,
  xlim = NULL,
  layout.params = list(as.graph = TRUE),
  hang = 0.1,
  ...
)
}
\arguments{
\item{tr}{phylo object}

\item{mapping}{aesthetic mapping}

\item{layout}{one of 'rectangular', 'dendrogram', 'slanted', 'ellipse', 'roundrect',
'fan', 'circular', 'inward_circular', 'radial', 'equal_angle', 'daylight' or 'ape'}

\item{open.angle}{open angle, only for 'fan' layout}

\item{mrsd}{most recent sampling date}

\item{as.Date}{logical whether using Date class in time tree}

\item{yscale}{y scale}

\item{yscale_mapping}{yscale mapping for category variable}

\item{ladderize}{logical (default \code{TRUE}). Should the tree be re-organized to have a 'ladder'
aspect?}

\item{right}{logical. If \code{ladderize = TRUE}, should the ladder have the smallest clade on the
right-hand side? See \code{\link[ape:ladderize]{ape::ladderize()}} for more information.}

\item{branch.length}{variable for scaling branch, if 'none' draw cladogram}

\item{root.position}{position of the root node (default = 0)}

\item{xlim}{x limits, only works for 'inward_circular' layout}

\item{layout.params}{list, the parameters of layout, when layout is a function.
\code{as.graph=TRUE} and \code{layout} is a function, the coordinate will be re-calculated
as a \code{igraph} object, if \code{as.graph=FALSE} and \code{layout}, the coordinate will be
re-calculated keep original object \code{phylo} or \code{treedata}.}

\item{hang}{numeric The fraction of the tree plot height by which labels should hang
below the rest of the plot. A negative value will cause the labels to hang down from 0. This
parameter only work with the 'dendrogram' layout for 'hclust' like class, default is 0.1.}

\item{...}{additional parameter

some dot arguments:
\itemize{
\item \code{nsplit} integer, the number of branch blocks divided when 'continuous' is not "none", default is 200.
}}
}
\value{
tree
}
\description{
drawing phylogenetic tree from phylo object
}
\examples{
require(ape) 
tr <- rtree(10)
ggtree(tr)
}
\references{
\enumerate{
\item G Yu, TTY Lam, H Zhu, Y Guan (2018). Two methods for mapping and visualizing associated data
on phylogeny using ggtree. Molecular Biology and Evolution, 35(2):3041-3043.
\url{https://doi.org/10.1093/molbev/msy194}
\item G Yu, DK Smith, H Zhu, Y Guan, TTY Lam (2017). ggtree: an R package for
visualization and annotation of phylogenetic trees with their covariates and
other associated data. Methods in Ecology and Evolution, 8(1):28-36.
\url{https://doi.org/10.1111/2041-210X.12628}
}

For more information, please refer to
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\seealso{
\code{\link[=geom_tree]{geom_tree()}}
}
\author{
Yu Guangchuang
}
