% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_options.R
\name{networkOptions}
\alias{networkOptions}
\title{Setup network options}
\usage{
networkOptions(
  method = "pearson",
  unweighted = TRUE,
  cutoff = 0,
  centrality = "degree",
  minDegree = 0,
  nCores = 1,
  transFun = function(x) x,
  min.degree = deprecated(),
  n.cores = deprecated(),
  trans.fun = deprecated()
)
}
\arguments{
\item{method}{in case of correlation and covariance, which method to use.}

\item{unweighted}{calculate degree using unweighted network.}

\item{cutoff}{cuttoff value in network edges to trim the network.}

\item{centrality}{centrality measure to use, currently only supports degree.}

\item{minDegree}{minimum value that individual penalty weight can take.}

\item{nCores}{number of cores to use, default to 1.}

\item{transFun}{See details below.}

\item{min.degree}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{n.cores}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{trans.fun}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

The \code{transFun} argument takes a function definition that will apply a
transformation to the penalty vector calculated from the degree. This
transformation allows to change how the penalty is applied.}
}
\value{
a list of options
}
\description{
Setup network options, such as using weighted or unweighted degree,
which centrality measure to use
}
\examples{
networkOptions(unweighted = FALSE)
}
\seealso{
\code{\link[=glmOrphan]{glmOrphan()}} and \code{\link[=glmDegree]{glmDegree()}}
}
