% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{intern.plot}
\alias{intern.plot}
\title{Internal function}
\usage{
intern.plot(u, upper = NULL, xlab = "indices")
}
\arguments{
\item{u}{influence:
numeric vector of length \code{n}}

\item{upper}{critical values:
numeric vector of length \code{n}}

\item{xlab}{label of horizontal axis:
character string}
}
\value{
The function plots the arguments.
}
\description{
This function plots the individual contributions
to the test statistic.
It is called by the function \code{\link{proprius}}.
}
\examples{
# simulate influences
set.seed(1)
u <- rchisq(n=100,df=2)

# influence plot
upper <- rep(qchisq(p=0.95,df=2),times=100)
intern.plot(u,upper)

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)
}
\seealso{
This is an \code{\link{internal}} function. The user functions
are \code{\link{cursus}}, \code{\link{omnibus}},
and \code{\link{proprius}}.
}
\keyword{internal}
