% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_functions.R
\name{omnibus}
\alias{omnibus}
\title{Omnibus test}
\usage{
omnibus(y, X, offset = NULL, group = NULL,
        mu = NULL, phi = NULL,
        perm = 1000, kind = 1)
}
\arguments{
\item{y}{\strong{response variable}\strong{:}
numeric vector of length \code{n}}

\item{X}{\strong{one covariate set}\strong{:}
numeric matrix with \code{n} rows (samples)
and \code{p} columns (covariates);
\cr \strong{multiple covariate sets}\strong{:}
list of numeric matrices with \code{n} rows (samples)}

\item{offset}{numeric vector of length \code{n}}

\item{group}{confounding variable\strong{:}
factor of length \code{n}}

\item{mu}{mean parameters\strong{:}
numeric vector of length \code{1} or \code{n}}

\item{phi}{dispersion parameter\strong{:}
non-negative real number}

\item{perm}{number of iterations\strong{:}
positive integer}

\item{kind}{computation \strong{:}
number between 0 and 1}
}
\value{
The function returns a dataframe,
with the p-value in the first column,
and the test statistic in the second column.
}
\description{
Test of association between a count response and
one or more covariate sets.
This test may be conceptualised as
a test of overall significance in regression analysis,
where the response variable is overdispersed, and where
the number of explanatory variables (\code{p})
exceeds the sample size (\code{n}).
The negative binomial distribution accounts for overdispersion
and a random effect model accounts for high dimensionality
(\code{p}>>\code{n}).
}
\details{
The user can provide a common \code{mu} for all samples
or sample-specific \code{mu}, and a common \code{phi}.
Setting \code{phi} equal to zero is equivalent
to using the Poisson model.
If \code{mu} is missing, then \code{mu} is estimated from \code{y}.
If \code{phi} is missing, then \code{mu} and \code{phi}
are estimated from \code{y}.
The \code{offset} is only taken into account
for estimating \code{mu} or \code{phi}.
By default the offset is \code{rep(1,n)}.

The user can provide the \strong{confounding} variable \code{group}.
Note that each level of \code{group} must appear at least twice
in order to allow stratified permutations.

Efficient alternatives to classical \strong{permutation} (\code{kind=1})
are the method of control variates (\code{kind=0})
and permutation in chunks (0 < \code{kind} < 1)
\link[=intern.crude]{details}.
}
\examples{
# simulate high-dimensional data
n <- 30; p <- 100
y <- rnbinom(n,mu=10,size=1/0.25)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)

# hypothesis testing
omnibus(y,X)

}
\references{
A Rauschenberger, MA Jonker, MA van de Wiel, and RX Menezes (2016).
"Testing for association between RNA-Seq and high-dimensional data",
\emph{BMC Bioinformatics}. 17:118.
\href{http://dx.doi.org/10.1186/s12859-016-0961-5}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0961-5.pdf}{pdf}
(open access)

RX Menezes, L Mohammadi, JJ Goeman, and JM Boer (2016).
"Analysing multiple types of molecular profiles simultaneously:
connecting the needles in the haystack",
\emph{BMC Bioinformatics}. 17:77.
\href{http://dx.doi.org/10.1186/s12859-016-0926-8}{html}
\href{http://www.biomedcentral.com/content/pdf/s12859-016-0926-8.pdf}{pdf}
(open access)

S le Cessie, and HC van Houwelingen (1995).
"Testing the fit of a regression model 
via score tests in random effects models",
\emph{Biometrics}. 51:600-614.
\href{http://dx.doi.org/10.2307/2532948}{html}
\href{http://www.jstor.org/stable/pdf/2532948.pdf?acceptTC=true}{pdf}
(restricted access)
}
\seealso{
The function \code{\link{proprius}} calculates
the contributions of individual samples or covariates
to the test statistic.
The function \code{\link{cursus}} tests for association
between RNA-Seq and local genetic or epigenetic alternations
across the whole genome.
All other functions of the R package \code{\link{globalSeq}}
are \code{\link{internal}}.
}
\keyword{methods}
