% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obotools.R
\name{obo2graphNEL}
\alias{obo2graphNEL}
\alias{efo.obo.g}
\alias{node2uri}
\alias{uri2node}
\title{convert a typical OBO text file to a graphNEL instance (using Term elements)}
\usage{
obo2graphNEL(
  obo = "human-phenotype-ontology.obo",
  kill = "\\\\[Typedef\\\\]",
  killTrailSp = TRUE
)
}
\arguments{
\item{obo}{string naming a file in OBO format}

\item{kill}{entity types to be excluded from processing -- probably this
should be in a 'keep' form, but for now this works.}

\item{killTrailSp}{In the textual version of EFO ca. Aug 2015, there is a
trailing blank in the tag field defining EFO:0000001, which is not present
in references to this term.  Set this to TRUE to eliminate this, or graphNEL
construction will fail to validate.}
}
\value{
a graphNEL instance
}
\description{
convert a typical OBO text file to a graphNEL instance (using Term elements)
}
\details{
Very rudimentary list and grep operations are used to retain sufficient
information to map the DAG to a graphNEL, using formal term identifiers as
node names and 'is-a' relationships as edges, and term names and other
metadata are assigned to nodeData components.
}
\note{
The OBO for Human Disease ontology is serialized as text with this
package.
}
\examples{

data(efo.obo.g)
requireNamespace("graph")
hn = graph::nodes(efo.obo.g)[1:5]
hn
graph::nodeData(efo.obo.g, hn[5])

}
\references{
For use with human disease ontology,
\url{http://www.obofoundry.org/cgi-bin/detail.cgi?id=disease_ontology}
}
\author{
VJ Carey <stvjc@channing.harvard.edu>
}
\keyword{models}
