getSampleData <- function( filename, group ){
  f <- H5Fopen(filename, flags = "H5F_ACC_RDONLY")
  g <- H5Gopen(f, group )
  legacyFields <- c( "SampleNames"="Sample", "SampleColumns"="Column", "SampleTypes"="Type", "SamplePatients"="Patient" )
  ret = list()
  num_attrs = H5Oget_num_attrs(g)
  for(i in seq_len(num_attrs)) {
    A = H5Aopen_by_idx( g, n = i - 1)
    attrname <- H5Aget_name(A)
    ret_i <- H5Aread(A)
    dim(ret_i) <- NULL
    ret[[attrname]] <- ret_i
    H5Aclose(A)
  }
  if( "AttributeStorage" %in% names(ret) ){
      ret = as.data.frame(h5read( filename, ret[["AttributeStorage"]] ), stringsAsFactors=FALSE )
  }
  for(attrname in names(legacyFields)){
    if( !(legacyFields[attrname] %in% names(ret))){
      if( !(attrname %in% names(ret)) & !(legacyFields[attrname] %in% names(ret))){
        stop( paste( "SampleData must contain", attrname, "or", legacyFields[attrname] ) )
      }
      ret[[legacyFields[attrname]]] <- ret[[attrname]]
    }
    ret[[attrname]] <- NULL
  }
  H5Gclose(g)
  H5Fclose(f)
  if( all( legacyFields %in% names(ret)) ){
    ret <- as.data.frame(ret)
    ret$Column = ret$Column + 1 #R counts from 1, Python from 0
    return(ret)
  }else{
    stop( paste( "Metadata is missing essential columns:", paste( setdiff( legacyFields, names(ret) ), collapse="," ) ) )
  }
}
