writeReference <- function( tallyFile, group, dnastring, blocksize = 1000000, verbose = TRUE ){
  minpos <- 1
  maxpos <- length(dnastring)
  nblocks = ceiling(maxpos/blocksize)
  blockstart = seq(minpos, by = blocksize, length = nblocks)
  blockend = blockstart + blocksize - 1
  blockend[length(blockend)] = min(blockend[length(blockend)], maxpos)
  blocks = paste(blockstart, blockend, sep = ":")
  for( b in seq(along=blocks) ){
    ref <- encodeDNAString(dnastring[blockstart[b]:blockend[b]])
    h5write( ref, tallyFile, paste( group, "Reference", sep = "/" ), index = list( c(blockstart[b]:blockend[b]) ) )
    if(verbose){
      print(paste(blocks[b], "written"))
    }
  }
  return(TRUE)
}