\name{binGenome}
\alias{binGenome}
\title{
Function for binning a genome.
}
\description{
Function for generating a \code{GRanges} representation of a binning of the genome given in the \code{reference} object.
}
\usage{
binGenome(reference, binsize = 1e+06, chroms = seqnames(reference))
}
\arguments{
  \item{reference}{
  A \code{BSgenome} object.
}
  \item{binsize}{
  Size of bins along the genome.
}
  \item{chroms}{
  Which chromosomes to use, defaults to all chromosome described as \code{seqnames} of the \code{reference} object.
}
}
\details{
This function creates a \code{GRanges} object that represents bins of size \code{binsize} along the genome represented by the \code{reference} object.
}
\value{
A \code{GRanges} object that represents bins of size \code{binsize} along the genome represented by the \code{reference} object, includes special handling of chromosomes shorter than \code{binsize} and the last bin of each chromosome.
}
\author{
Paul Theodor Pyl
}
\seealso{
\code{\link{defineBlocks}}
}
\examples{
library(BSgenome.Hsapiens.NCBI.GRCh38)
bins <- binGenome(Hsapiens, binsize = 100e6, chroms = c("1","2","3","X","MT"))
bins
}
