\name{mergeTallyFiles}
\alias{mergeTallyFiles}
\title{Merging multiple tally files into one}
\description{
Function to merge multiple tally files by genomic position (i.e. gluing samples together)
}
\usage{
mergeTallyFiles( inputFiles, destFile, destGroup, blockSize = 1e6, sampleDims = c(), positionDims = c() )
}
\arguments{
  \item{inputFiles}{A list mapping input file names to the groups within them from which the data shall be taken (e.g. "example.tally.hfs5" -> "/ExampleStudy/16")}
  \item{destFile}{Name of the file that should be created}
  \item{destGroup}{Group within \code{destFile} that will hold the merged data}
  \item{blockSize}{Size of the blocks in bases that the merging will be performed in}
  \item{sampleDims}{List mapping dataset names to their respective sample dimension, e.g. "Counts" -> 2 - has the standard datasets included by default}
  \item{positionDims}{List mapping dataset names to their respective position dimension, e.g. "Counts" -> 4 - has the standard datasets included by default}
}
\details{
This function merges tally data from a list of tally files into a new destination file.
}
\value{
  [None] -- prints progress messages along the way.
}
\author{
Paul Pyl
}
\examples{
\dontrun{
mergeTallyFiles{ # merging a file to itself, i.e. "doubling" it
  list(
    "example.tally.hfs5" = "/ExampleStudy/16",
    "example.tally.hfs5" = "/ExampleStudy/16"
  ),
  "test.merge.hfs5",
  "/MergedStudy/16"}
}
}