% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotHeatmapMeta.R
\name{plotHeatmapMeta}
\alias{plotHeatmapMeta}
\title{Plot a Meta-region plot from heatmaps}
\usage{
plotHeatmapMeta(hm_list, binsize = 1, colors = gg_col(length(hm_list)),
  addReferenceLine = FALSE)
}
\arguments{
\item{hm_list}{A list of heatmaps}

\item{binsize}{Integer, size of bins to use in plot}

\item{colors}{Color to use for each heatmap}

\item{addReferenceLine}{Logical, add reference line at zero or not

This function creates a meta-region plot from 1 or more heatmaps with the same
coordinates. A meta-region plot graphs the sum of the signal at each position in
each heatmap rather than visualising the signal in two dimensions. Often binning
is required to smooth noisy signal.}
}
\value{
invisible(0)
}
\description{
Plot a Meta-region plot from heatmaps
}
\examples{
data(HeatmapExamples)
plotHeatmapMeta(hm, color="steelblue")
}
