% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soft_neighbourhood.R
\name{scanHoods}
\alias{scanHoods}
\title{Scan cellular neighbourhoods.}
\usage{
scanHoods(
  m,
  mode = c("proximityFocused", "smoothFadeout"),
  tau = NA,
  t_init = NA
)
}
\arguments{
\item{m}{Distance matrix. Can be obtained from function findNearCells.}

\item{mode}{Character. Either proximityFocused or smoothFadeout.
By default is proximityFocused.}

\item{tau}{The hyperparameter tau, by default is median(m**2)/5}

\item{t_init}{An initial tau. In the smoothFadeout mode, user can provide
an initial tau for optimization.}
}
\value{
A probability matrix.
}
\description{
Scan cellular neighbourhoods.
}
\examples{

m <- matrix(abs(rnorm(1000 * 100)), 1000, 100)

pm <- scanHoods(m)

}
