% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iSEEmarker.R
\name{iSEEmarker}
\alias{iSEEmarker}
\title{iSEEmarker}
\usage{
iSEEmarker(
  sce,
  reddim_type = "TSNE",
  clusters = colnames(colData(sce))[1],
  groups = colnames(colData(sce))[1],
  selection_plot_format = c("ColumnDataPlot", "ReducedDimensionPlot")
)
}
\arguments{
\item{sce}{SingleCellExperiment object}

\item{reddim_type}{A string vector containing the dimensionality reduction}

\item{clusters}{A character string containing the name of the
clusters/cell-type/state...(as listed in the colData of the sce)}

\item{groups}{A character string of the groups/conditions...(as it appears in
the colData of the sce)}

\item{selection_plot_format}{A string character containing the class of the panel.
It can be either \code{ColumnDataPlot} or \code{ReducedDimensionPlot}}
}
\value{
A list of "Panel" objects specifying the initial state of iSEE
instance
}
\description{
\code{iSEEmarker()} creates an initial state of an iSEE instance for interactive
exploration of marker genes through the \code{DynamicMarkerTable} panel, synchronizing
selections with a \code{ReducedDimensionPlot} and a \code{FeatureAssayPlot} to visualize
the expression of selected marker genes
}
\examples{
sce <- scRNAseq::RichardTCellData()
sce <- scuttle::logNormCounts(sce)
sce <- scater::runPCA(sce)
sce <- scater::runTSNE(sce)
cluster <- "stimulus"
group <- "single cell quality"
initial <- iSEEmarker(sce = sce, clusters = cluster, groups = group,
selection_plot_format = "ColumnDataPlot")


}
