% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FeatureSetTable.R
\name{FeatureSetTable-class}
\alias{FeatureSetTable-class}
\alias{FeatureSetTable}
\alias{initialize,FeatureSetTable-method}
\alias{.fullName,FeatureSetTable-method}
\alias{.panelColor,FeatureSetTable-method}
\alias{.cacheCommonInfo,FeatureSetTable-method}
\alias{.refineParameters,FeatureSetTable-method}
\alias{.defineDataInterface,FeatureSetTable-method}
\alias{.hideInterface,FeatureSetTable-method}
\alias{.defineOutput,FeatureSetTable-method}
\alias{.generateOutput,FeatureSetTable-method}
\alias{.createObservers,FeatureSetTable-method}
\alias{.renderOutput,FeatureSetTable-method}
\alias{.multiSelectionDimension,FeatureSetTable-method}
\alias{.multiSelectionActive,FeatureSetTable-method}
\alias{.multiSelectionCommands,FeatureSetTable-method}
\alias{.multiSelectionAvailable,FeatureSetTable-method}
\alias{.multiSelectionClear,FeatureSetTable-method}
\alias{.definePanelTour,FeatureSetTable-method}
\title{Feature set table}
\description{
A table where each row is itself a feature set and can be clicked to transmit a multiple feature selection to another panel.
This relies on feature set collections that have been registered in the input \linkS4class{SummarizedExperiment},
see \code{\link{registerFeatureSetCollections}} for more details.
If no collections have been registered, we default to the GO and KEGG collections from \code{\link{createGeneSetCommands}}.
}
\section{Slot overview}{

The following slots control the feature sets in use:
\itemize{
\item \code{Collection}, string specifying the type of feature set collection to show.
Defaults to the first registered collection in the SummarizedExperiment.
}

The following slots control the table selections:
\itemize{
\item \code{Selected}, a string containing the name of the currently selected gene set.
Defaults to \code{""}, i.e., no selection.
\item \code{Search}, a string containing the regular expression for the global search.
Defaults to \code{""}, i.e., no search.
\item \code{SearchColumns}, a character vector where each entry contains the search string for each column.
Defaults to an empty character vector, i.e., no search.
}

In addition, this class inherits all slots from its parent \linkS4class{Panel} class.
}

\section{Constructor}{

\code{FeatureSetTable(...)} creates an instance of a FeatureSetTable class,
where any slot and its value can be passed to \code{...} as a named argument.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{FeatureSetTable} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.cacheCommonInfo}(x)} adds a \code{"FeatureSetTable"} entry containing \code{available.sets}, a named list of DataFrames containing information about the individual gene sets for each collection.
This will also call the equivalent \linkS4class{Panel} method.
\item \code{\link{.refineParameters}(x, se)} replaces \code{NA} values in \code{Collection} with the first valid collection.
It also replaces \code{NA} values for \code{Selected} with the first valid set in the chosen collection.
This will also call the equivalent \linkS4class{Panel} method.
}

For defining the interface:
\itemize{
\item \code{\link{.defineDataInterface}(x, se, select_info)} returns a list of interface elements for manipulating all slots described above.
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
\item \code{\link{.fullName}(x)} will return \code{"Gene set table"}.
\item \code{\link{.hideInterface}(x)} will return \code{TRUE} for UI elements related to multiple selections,
otherwise calling the method for \linkS4class{Panel}.
\item \code{\link{.defineOutput}(x)} will return a HTML element containing a \code{\link{datatable}} widget.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all new slots described above, as well as in the parent classes via the \linkS4class{Panel} method.
}

For creating the table:
\itemize{
\item \code{\link{.generateOutput}(x, envir)} will create a data.frame of gene set descriptions in \code{envir}.
It will also return the commands required to do so and the name of the variable corresponding to said data.frame.
\item \code{\link{.renderOutput}(x, se, ..., output, pObjects, rObjects)}
will add a \code{\link{datatable}} widget to the output,
which is used to render the aforementioned data.frame.
}

For controlling the multiple selections:
\itemize{
\item \code{\link{.multiSelectionDimension}(x)} returns \code{"row"}.
\item \code{\link{.multiSelectionCommands}(x, index)} returns a string specifying the commands to be used to extract the identities of the genes in the currently selected set.
\code{index} is ignored.
\item \code{\link{.multiSelectionActive}(x)} returns the name of the currently selected gene set,
unless no selection is made, in which case \code{NULL} is returned.
\item \code{\link{.multiSelectionClear}(x)} returns \code{x} but with the \code{Selected} slot replaced by an empty string.
\item \code{\link{.multiSelectionAvailable}(x, contents)} returns \code{contents$available},
which is set to the number of features in \code{se}.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a panel-specific tour.
}
}

\examples{
library(scRNAseq)
sce <- LunSpikeInData(location=FALSE)

library(scater)
sce <- logNormCounts(sce)

library(scran)
rowData(sce) <- cbind(rowData(sce), modelGeneVarWithSpikes(sce, "ERCC"))

cmds <- createGeneSetCommands(collections="GO",
    organism="org.Mm.eg.db", identifier="ENSEMBL")
sce <- registerFeatureSetCommands(sce, cmds)

# Setting up the application.
gst <- FeatureSetTable(PanelId=1L)

rdp <- RowDataPlot(RowSelectionSource="FeatureSetTable1",
    ColorBy="Row selection",
    XAxis="Row data", XAxisRowData="mean", YAxis="total")

rdt <- RowDataTable(RowSelectionSource="FeatureSetTable1")

if (interactive()) {
    iSEE(sce, initial=list(gst, rdp, rdt))
}

}
\author{
Aaron Lun
}
