% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_iasva.R
\name{fast_iasva}
\alias{fast_iasva}
\title{A function for fast IA-SVA}
\usage{
fast_iasva(Y, X, intercept = TRUE, num.sv = NULL, pct.cutoff = 1,
  num.tsv = NULL, tol = 1e-10, verbose = FALSE)
}
\arguments{
\item{Y}{A SummarizedExperiment class containing read counts where
rows represent genes and columns represent samples.}

\item{X}{A design matrix of known variables (e.g., patient ID, gender).}

\item{intercept}{If intercept = FALSE, the linear 
intercept is not included in the model.}

\item{num.sv}{number of surrogate variables to estimate.}

\item{pct.cutoff}{percetage threshold for SV retention. 
IA-SVA computes the percentage of unmodeled variance explained by the
 putative hidden factor and compare it with the user-defined threshold. 
 If the percentage is greater than the threshold, SV is retained.}

\item{num.tsv}{num of top singular values to be used in computing the
percentage of unmodeled variation explained by the putative hidden factor.
 If num.tsv = NULL, all singular values are used.}

\item{tol}{stopping tolerance for the augmented implicitly restarted 
Lanczos bidiagonalization algorithm}

\item{verbose}{If verbose = TRUE, the function outputs detailed messages.}
}
\value{
sv matrix of estimated surrogate variables,
 one column for each surrogate variable.

pct vector of percentages of unmodeled variance explained 
by each surrogate variable, one value for each surrogate variable.

n.sv number of obtained surrogate variables.
}
\description{
The iterative procedure of fast IA-SVA is implemented in this 
function (fast_iasva). fast_iasva() iteratively identifies a hidden factor
for unwanted variation while accounting for all known factors, and
computes its contribution  (i.e., the percentage of unmodeled variation
explained by the hidden factor) on the unmodeled variation in the data. 
If the contribution is greater than a user-defined cutoff (pct.cutoff,
 default = 1%), the factor is retained and used as a known variable in 
 the next iteration to find further hidden factors.
}
\examples{
counts_file <- system.file("extdata", "iasva_counts_test.Rds",
 package = "iasva")
counts <- readRDS(counts_file)
anns_file <- system.file("extdata", "iasva_anns_test.Rds",
 package = "iasva")
 anns <- readRDS(anns_file)
Geo_Lib_Size <- colSums(log(counts + 1))
Patient_ID <- anns$Patient_ID
mod <- model.matrix(~Patient_ID + Geo_Lib_Size)
summ_exp <- SummarizedExperiment::SummarizedExperiment(assays = counts)
iasva.res <- fast_iasva(summ_exp, mod[, -1], num.sv = 5)
}
