% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{igvShiny}
\alias{igvShiny}
\title{Create an igvShiny instance}
\usage{
igvShiny(
  genomeOptions,
  width = NULL,
  height = NULL,
  elementId = NULL,
  displayMode = "squished",
  tracks = list()
)
}
\arguments{
\item{genomeOptions}{a list with these fields: genomeName, initialLocus, 
annotation, dataMode, fasta, fastaIndex, stockGenome, validated}

\item{width}{a character string, standard css notations, 
either e.g., "1000px" or "95\%"}

\item{height}{a character string, needs to be an explicit pixel measure, 
e.g., "800px"}

\item{elementId}{a character string, the html element id within which
igv is created}

\item{displayMode}{a character string, default "SQUISHED".}

\item{tracks}{a list of track specifications to be created
and displayed at startup}
}
\value{
the created widget
}
\description{
This function is called in the server function of your shiny app
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{igvShiny}
