% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igvShiny.R
\name{loadBedGraphTrack}
\alias{loadBedGraphTrack}
\alias{loadGenomeAnnotationTrack}
\title{load a scored genome annotation track provided as a data.frame}
\usage{
loadBedGraphTrack(
  session,
  id,
  trackName,
  tbl,
  color = "gray",
  trackHeight = 30,
  autoscale,
  autoscaleGroup = -1,
  min = NA_real_,
  max = NA_real_,
  deleteTracksOfSameName = TRUE,
  quiet = TRUE
)
}
\arguments{
\item{session}{an environment or list, provided and managed by shiny}

\item{id}{character string, the html element id of this widget instance}

\item{trackName}{character string}

\item{tbl}{data.frame, with at least "chrom" "start" "end" "score" columns}

\item{color}{character string, a legal CSS color, or "random", 
"gray" by default}

\item{trackHeight}{an integer, 30 (pixels) by default}

\item{autoscale}{logical}

\item{autoscaleGroup}{numeric(1) defaults to -1}

\item{min}{numeric, consulted when autoscale is FALSE}

\item{max}{numeric, consulted when autoscale is FALSE}

\item{deleteTracksOfSameName}{logical, default TRUE}

\item{quiet}{logical, default TRUE, controls verbosity}
}
\value{
nothing
}
\description{
load a genome annotation track provided as a data.frame
}
\examples{
library(igvShiny)
demo_app_file <-
  system.file(package = "igvShiny", "demos", "igvShinyDemo.R")
if (interactive()) {
  shiny::runApp(demo_app_file)
}

}
\keyword{track_loaders}
